set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1342',
      '31321420',
      4,
      54.183989,
      '1444013',
      157,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      8.334578,
      55.823344,
      1.748219,
      NULL,
      1.114270,
      0.208677,
      3,
      0,
      0.070568,
      1.193431,
      0,
      1.504306,
      3,
      1,
      3.155076,
      NULL,
      1.318505,
      1,
      1,
      0.775830,
      2,
      1,
      1,
      1,
      0,
      0.676682,
      1,
      NULL,
      2,
      NULL,
      1.093832,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.849362,
      NULL,
      NULL,
      1,
      1,
      1,
      3.596370,
      NULL,
      0,
      1.485153,
      3.575387,
      NULL,
      1.123666,
      NULL,
      0,
      0.851975,
      0,
      0,
      NULL,
      0,
      0.063517,
      0.128454,
      3,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.414951,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.982501,
      0.897793,
      1.025900,
      0.605348,
      0.324212,
      0,
      1,
      NULL,
      1.803811,
      2,
      0.186812,
      1,
      NULL,
      0,
      3.680652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.776259,
      NULL,
      5,
      1,
      NULL,
      NULL,
      2.069925,
      9.178645,
      7.350687,
      8.934827,
      NULL,
      4.943021,
      2.848187,
      3.713437,
      8.511197,
      1,
      NULL,
      0.312708,
      1.209626,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0.980468,
      0.836625,
      0,
      0.753426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.348078,
      1.376327,
      2.683161,
      6,
      0,
      1,
      0,
      1,
      5,
      0.525965,
      3.924752,
      0,
      NULL,
      NULL,
      NULL,
      3.249598,
      1,
      5.992598,
      0,
      4,
      0,
      0.503849,
      0.111972,
      NULL,
      NULL,
      0,
      10.490105,
      1.833060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.898975,
      1.847430,
      2.701306,
      0.004390,
      3.397882,
      3,
      1.755261,
      2,
      1.512376,
      3,
      NULL,
      1.859284,
      NULL,
      0.248779,
      1.014502,
      1,
      NULL,
      1.171962,
      NULL,
      0.333414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.512221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '4313',
      '2420',
      '',
      1,
      '132',
      NULL,
      '',
      4,
      NULL,
      '0442',
      '',
      5,
      3.469704,
      0.641553,
      3,
      0,
      0,
      3,
      0.286929,
      3.176077);
commit;
end;
/


