set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7530402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-8-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1104',
      '32343030',
      12,
      50,
      '1424232',
      225,
      NULL,
      3.348390,
      NULL,
      NULL,
      4.209830,
      ' 7-24-1982',
      30,
      39.618048,
      0.465404,
      NULL,
      NULL,
      1,
      3,
      1.342530,
      1,
      1.993908,
      0,
      0,
      0,
      NULL,
      1.963118,
      0,
      NULL,
      0,
      1.076229,
      0,
      0,
      0.060430,
      NULL,
      0,
      1,
      NULL,
      3.216873,
      0,
      1.311239,
      1.038880,
      1.516263,
      0.900090,
      NULL,
      NULL,
      1.486402,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.309427,
      0,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      1.657155,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3.376011,
      NULL,
      0,
      1.207011,
      NULL,
      1,
      NULL,
      1,
      1.322891,
      1.677702,
      1.152647,
      1.241033,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.101935,
      0.216626,
      0.605930,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.402843,
      3,
      3.555027,
      0,
      0.351544,
      7.911550,
      6,
      6.679981,
      NULL,
      4.703820,
      0.248072,
      3,
      NULL,
      4.680242,
      NULL,
      3.262952,
      NULL,
      NULL,
      NULL,
      0.582408,
      1.731197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1.236381,
      0,
      1.877427,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.636144,
      NULL,
      8.072904,
      0.716103,
      2,
      5.554780,
      0.508780,
      0,
      0,
      2,
      1.866932,
      0.652359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.219937,
      0.349157,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.652396,
      4,
      1.373920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689315,
      0.964984,
      3.967816,
      NULL,
      3.267795,
      3,
      0.996069,
      0,
      1.249356,
      0,
      3,
      1.096179,
      1.780306,
      0,
      0.730548,
      NULL,
      1,
      0.689620,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '3310',
      '2443',
      NULL,
      2.714765,
      '132',
      NULL,
      NULL,
      5.632056,
      '3224',
      '4011',
      '',
      0,
      3,
      2.882047,
      2,
      1.445311,
      NULL,
      3.094785,
      3,
      NULL);
commit;
end;
/


