set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9698125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '311',
      '02',
      31,
      4,
      '1033032',
      NULL,
      2,
      1,
      1,
      NULL,
      5.332907,
      NULL,
      6.602988,
      29,
      1.312803,
      NULL,
      2,
      1.605344,
      NULL,
      0.282097,
      0,
      2.302062,
      0,
      1.547284,
      0.687188,
      1,
      0.298822,
      0,
      NULL,
      1,
      0.189565,
      NULL,
      3.637948,
      0,
      0,
      1.347410,
      0,
      1.036989,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414998,
      1.950715,
      0.317246,
      1.091798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.067525,
      1,
      1.011710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.969276,
      1,
      0.707301,
      NULL,
      3.177404,
      6,
      NULL,
      1,
      NULL,
      2.288354,
      2,
      NULL,
      NULL,
      0.615055,
      0.318422,
      NULL,
      0,
      1.476967,
      0,
      NULL,
      1.134196,
      0,
      NULL,
      1,
      NULL,
      0.180332,
      0.407582,
      1,
      0,
      0,
      1,
      1,
      1,
      1.606236,
      3.459848,
      0,
      0,
      NULL,
      3.069356,
      2,
      3.831297,
      NULL,
      3.568367,
      0.441827,
      5.173120,
      4,
      1,
      4.029592,
      2.153769,
      NULL,
      NULL,
      6,
      0.727420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.619575,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      4.460164,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.373136,
      0.905678,
      0.239152,
      NULL,
      NULL,
      NULL,
      0,
      0.727162,
      2.198535,
      1,
      1.245350,
      1,
      3.716789,
      1.828054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      0,
      2.317914,
      1,
      1,
      1.168943,
      0,
      1.144462,
      1,
      NULL,
      0.391627,
      0,
      NULL,
      1.025893,
      1,
      1.476313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.905084,
      0.936160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.377845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.764345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012459,
      NULL,
      NULL,
      NULL,
      NULL,
      0.911390,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.499725,
      0.316331,
      NULL,
      0.093858,
      0.044831,
      1.228554,
      NULL,
      1.241561,
      '11011',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      1.004280,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


