set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9698125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '204',
      '11134040',
      0,
      10,
      '1303012',
      31.156159,
      1,
      3,
      1,
      '142433',
      1,
      ' 2-24-1986',
      3.580834,
      53.831155,
      0.985466,
      NULL,
      3.220464,
      NULL,
      0.414902,
      1,
      NULL,
      1,
      1.377303,
      NULL,
      NULL,
      1,
      0.823788,
      0,
      0.788718,
      NULL,
      NULL,
      0.806581,
      0.480204,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.066519,
      0.064683,
      1.516429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042403,
      NULL,
      0.007808,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.405942,
      NULL,
      3,
      NULL,
      0,
      0.119649,
      6.170939,
      1.324564,
      1,
      3,
      1.649060,
      0.295238,
      NULL,
      3.197551,
      1,
      0.027234,
      1,
      NULL,
      0.926096,
      NULL,
      1.319607,
      1.716630,
      2.647723,
      0,
      0,
      1,
      5,
      1.835146,
      0.938590,
      0.398305,
      0,
      3,
      0,
      0.527256,
      0,
      NULL,
      1.398715,
      NULL,
      6.712662,
      NULL,
      5.313336,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.698680,
      NULL,
      1,
      3,
      1.318255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.472770,
      1,
      NULL,
      1,
      1.883651,
      NULL,
      0.212676,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.306571,
      NULL,
      NULL,
      NULL,
      NULL,
      1.614856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.598867,
      1.533006,
      7,
      0.162275,
      1,
      2,
      2.981737,
      1,
      NULL,
      NULL,
      NULL,
      2.181811,
      0.023273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816384,
      1.102662,
      0,
      2,
      3.479439,
      2.329499,
      1.556887,
      0,
      2.436129,
      NULL,
      1.770729,
      0.895761,
      1.283761,
      1.804653,
      1.264255,
      0,
      0,
      0,
      1.095415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.292775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.409710,
      '10321',
      '23123',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0.501672,
      NULL,
      1.399990,
      4.991770,
      2,
      4.987807,
      3.852175,
      2,
      2);
commit;
end;
/


