set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-11-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      NULL,
      NULL,
      9.841512,
      4,
      3,
      NULL,
      NULL,
      2.372086,
      NULL,
      0,
      NULL,
      0.584394,
      NULL,
      0,
      0.625837,
      1.929484,
      NULL,
      3.397824,
      1.343869,
      NULL,
      1.573802,
      NULL,
      NULL,
      NULL,
      0.056527,
      0.429356,
      0.434944,
      0.155311,
      NULL,
      5,
      1,
      1,
      NULL,
      3,
      1,
      4.203775,
      NULL,
      5,
      3.745445,
      3.451382,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      2,
      2.833424,
      0,
      0,
      NULL,
      0.767498,
      0.968892,
      1.656158,
      1.646158,
      NULL,
      1.510135,
      NULL,
      0.731186,
      0,
      2.447514,
      3,
      2,
      0,
      1.881744,
      1,
      8,
      1,
      NULL,
      0.247779,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      3,
      0.903816,
      0,
      NULL,
      0,
      1,
      NULL,
      2,
      0,
      0.422760,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.992233,
      2,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      1,
      3.809218,
      0.496416,
      4.264774,
      1,
      7,
      4,
      1.312934,
      5,
      4,
      7.511633,
      NULL,
      1,
      1.817403,
      8.798051,
      5.225246,
      5.961781,
      NULL,
      1.648199,
      3,
      1.015181,
      NULL,
      7.091097,
      0.092599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.480061,
      0,
      1,
      0,
      NULL,
      1.285935,
      0.770047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.171155,
      NULL,
      5,
      NULL,
      1,
      1.863520,
      NULL,
      0,
      1,
      0.000690,
      NULL,
      7.904486,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.308138,
      6,
      1.535051,
      5.279775,
      4,
      2,
      1.752622,
      NULL,
      NULL,
      NULL,
      1.279877,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.584454,
      2.895101,
      3,
      0.242579,
      3.558687,
      1.343470,
      NULL,
      3,
      1,
      2,
      2.489851,
      0,
      1,
      NULL,
      NULL,
      1.351771,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '',
      0.465061,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


