set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-5-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      NULL,
      NULL,
      '4432142',
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      ' 3-27-1995',
      6.054833,
      NULL,
      1,
      NULL,
      3,
      2.690088,
      1.316736,
      1.078149,
      1.839787,
      1.296749,
      1,
      1,
      0,
      1.701887,
      5.402638,
      NULL,
      1,
      0,
      1.072124,
      NULL,
      3,
      0.933579,
      1,
      0,
      0.566390,
      0,
      2,
      NULL,
      1.559053,
      0.698055,
      1,
      0.296715,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.678469,
      0.665113,
      1.408674,
      0,
      1,
      0,
      NULL,
      NULL,
      1.120262,
      2.670414,
      0.907339,
      2.527683,
      0,
      1,
      1.447000,
      0,
      0.867281,
      1.888019,
      1,
      0,
      0.039560,
      5,
      0.318084,
      0,
      0,
      1,
      0.812177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0.706070,
      1.675745,
      1,
      1,
      NULL,
      1,
      0,
      0.700017,
      NULL,
      0.818573,
      0.237503,
      0.806186,
      0,
      NULL,
      1.950890,
      NULL,
      NULL,
      2,
      0.262595,
      0.179508,
      6,
      0.596876,
      0,
      0,
      1,
      0,
      0.087421,
      1.835839,
      5.305471,
      0,
      NULL,
      1,
      NULL,
      1,
      4.229485,
      1,
      1,
      6,
      0,
      5,
      5,
      3,
      3,
      5.938110,
      NULL,
      NULL,
      1.659536,
      3.725326,
      0.319275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.396472,
      1,
      1,
      0,
      1,
      1,
      1,
      1.585027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      8.284256,
      1.942660,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.386602,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.877185,
      NULL,
      2,
      1.505536,
      1,
      1.157261,
      NULL,
      NULL,
      NULL,
      1.343841,
      2.985836,
      1.086449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.442619,
      2.105037,
      NULL,
      3.322081,
      0.552711,
      0.936166,
      NULL,
      0.744277,
      3,
      1,
      1.225359,
      NULL,
      1.480572,
      1,
      0.751898,
      0,
      NULL,
      0,
      1.729530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.040754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '04214',
      '12430',
      '',
      0.122354,
      '',
      '',
      '',
      1.500281,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


