set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      31.921436,
      NULL,
      2,
      NULL,
      '431102',
      NULL,
      NULL,
      19,
      NULL,
      1.092198,
      NULL,
      3,
      2.595288,
      NULL,
      1.115333,
      0.063170,
      1.289139,
      3,
      0.094334,
      0.070098,
      0.257829,
      NULL,
      NULL,
      0,
      1.028882,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0.989712,
      0,
      4,
      1,
      2,
      1.886809,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.645319,
      0,
      0.724082,
      2.153695,
      NULL,
      1,
      0.696492,
      1,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.897414,
      0.581574,
      1.059207,
      NULL,
      3.925205,
      1.426350,
      1,
      1.466931,
      NULL,
      0,
      2,
      1,
      1.723768,
      NULL,
      NULL,
      0.531004,
      NULL,
      NULL,
      1,
      1.201673,
      2.044558,
      NULL,
      4,
      0.558504,
      0.400772,
      0,
      0,
      1.973128,
      0,
      NULL,
      1.383253,
      1.941270,
      1.043739,
      1.918134,
      1,
      1,
      1.719792,
      NULL,
      0.859945,
      7,
      0,
      5.685686,
      6,
      0.278326,
      3.842652,
      0,
      2,
      4,
      1.235027,
      4.948865,
      3,
      0.117734,
      NULL,
      0.661355,
      1,
      4.966717,
      8,
      7.853059,
      NULL,
      0,
      1,
      6,
      NULL,
      4,
      2.665955,
      0,
      2,
      1,
      0,
      9.499297,
      1.316341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.560368,
      1.650754,
      0,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.573075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.002000,
      0.485625,
      1.192293,
      NULL,
      NULL,
      NULL,
      2.544495,
      1,
      3.987122,
      3,
      3.549672,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831897,
      3.425205,
      3.534711,
      NULL,
      2.499701,
      NULL,
      1,
      0,
      0.750846,
      1.880659,
      NULL,
      0,
      1.617589,
      1,
      0.294124,
      1.366442,
      1.051484,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.413578,
      '11111',
      '23230',
      '',
      1.949345,
      NULL,
      NULL,
      '',
      2,
      '4014',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


