set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-10-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '4123101',
      17,
      4,
      NULL,
      2,
      NULL,
      1.717857,
      ' 6-26-1984',
      35,
      NULL,
      1,
      NULL,
      1.661447,
      2.662786,
      1,
      0,
      2.290884,
      NULL,
      NULL,
      0,
      0,
      1.928790,
      0.037600,
      0,
      0,
      0.390395,
      0.828221,
      1,
      3,
      0,
      0.134247,
      0.294170,
      0.889155,
      1.400108,
      4,
      NULL,
      0,
      2.286490,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.558785,
      1,
      1.817302,
      NULL,
      0.441429,
      1,
      1.165610,
      1.162319,
      1,
      0,
      0,
      1.950361,
      0.036280,
      0,
      3.413515,
      1.346365,
      NULL,
      3.717083,
      3,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1.633291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735876,
      1.947042,
      NULL,
      0.751381,
      4,
      0,
      1,
      1.084937,
      0.175997,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      1.971090,
      0.443547,
      NULL,
      1.749904,
      7,
      NULL,
      1.924507,
      1.644619,
      1,
      0.443220,
      0,
      0.165650,
      0,
      NULL,
      0,
      1,
      0.075188,
      NULL,
      0.854819,
      0.207342,
      NULL,
      4.075692,
      3,
      2.228735,
      3,
      1,
      NULL,
      NULL,
      4,
      2,
      5.335169,
      NULL,
      1,
      1,
      7.574931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.935972,
      1,
      0,
      NULL,
      0.790922,
      1,
      0.610398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.838609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.579711,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5.510697,
      NULL,
      NULL,
      NULL,
      0,
      1.352444,
      NULL,
      NULL,
      NULL,
      0.434095,
      1.575579,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.663673,
      3,
      1.897492,
      2,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.172987,
      0.860226,
      1,
      0.901556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.143531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.117255,
      '10402',
      NULL,
      '',
      1,
      '12034',
      NULL,
      '',
      2.007993,
      '4411',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


