set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-4-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      NULL,
      NULL,
      34,
      0,
      2.319807,
      1,
      NULL,
      3,
      NULL,
      19.113523,
      NULL,
      0,
      NULL,
      3,
      2,
      0.492927,
      0,
      0.615349,
      NULL,
      NULL,
      1,
      0.145313,
      1.160730,
      1.336950,
      1,
      1.712953,
      NULL,
      0.559707,
      1.098861,
      6,
      0.082394,
      0.789909,
      0,
      1.434816,
      0,
      NULL,
      1,
      1.198287,
      1,
      1.975225,
      0.648100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.760592,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      0.536315,
      1.711548,
      0.748617,
      1.205082,
      NULL,
      1,
      1,
      0.068686,
      2.145385,
      2.040841,
      1.293475,
      0.596365,
      1,
      1.538495,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.910180,
      NULL,
      NULL,
      NULL,
      1.037164,
      NULL,
      1,
      1.039778,
      NULL,
      NULL,
      1.310942,
      0.269479,
      0,
      1.371283,
      0,
      0.307891,
      1.739623,
      1.674961,
      0.385832,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1.236530,
      2,
      NULL,
      NULL,
      NULL,
      0.994733,
      0.873803,
      4,
      1.730163,
      0,
      0.035898,
      0.691432,
      NULL,
      0.071284,
      7,
      NULL,
      4.034068,
      0.621065,
      1,
      3,
      1,
      NULL,
      1.628191,
      0,
      0,
      3,
      NULL,
      1.293616,
      8,
      1.120844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1.820424,
      1,
      0,
      0.019788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.133531,
      NULL,
      NULL,
      NULL,
      3.580930,
      NULL,
      NULL,
      NULL,
      1.679203,
      0,
      1.000446,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.191616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      NULL,
      2,
      1.429444,
      1.972844,
      0,
      NULL,
      1,
      0.884778,
      NULL,
      0,
      1.891531,
      NULL,
      0.699271,
      1,
      0,
      0.388470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.936608,
      '10211',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      '41401',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


