set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      '2134122',
      24,
      6,
      2.917797,
      NULL,
      '230432',
      0,
      ' 5- 9-1995',
      39,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.659200,
      1,
      1,
      3,
      0,
      NULL,
      0.059548,
      NULL,
      0.753541,
      0,
      NULL,
      1.889265,
      1,
      4.147960,
      NULL,
      1,
      NULL,
      1,
      0,
      5,
      1,
      3,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1.919203,
      1.073184,
      0.480481,
      1,
      1,
      1.783496,
      1.291693,
      NULL,
      3.779951,
      1.513609,
      1,
      NULL,
      1.476291,
      1.548641,
      0.418457,
      1,
      2.442997,
      1.235433,
      NULL,
      0.976299,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.660041,
      NULL,
      NULL,
      1,
      2.265546,
      5.378839,
      0.088284,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.596588,
      1.348432,
      0,
      NULL,
      1.889559,
      0.919933,
      NULL,
      1.442898,
      1,
      1,
      NULL,
      1.332235,
      3.573627,
      1.153341,
      1,
      2,
      1.991884,
      3,
      NULL,
      3.759901,
      1,
      2,
      2.618478,
      5.134430,
      NULL,
      3.461234,
      0,
      1.908134,
      7,
      3.966192,
      2,
      2.495403,
      3,
      0,
      9.751298,
      3.297033,
      NULL,
      0,
      4.210527,
      NULL,
      NULL,
      NULL,
      NULL,
      0.730117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.732727,
      1,
      1,
      1,
      1.353519,
      1.365489,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.149901,
      0.618692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.971016,
      NULL,
      0.798866,
      1,
      1.784721,
      NULL,
      NULL,
      NULL,
      0.011236,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.364520,
      2,
      3.199542,
      2.897607,
      1,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      1.503610,
      NULL,
      NULL,
      1.652543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.382829,
      '12113',
      '',
      '',
      1,
      '04442',
      '',
      '',
      1.959514,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


