set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '323',
      '11',
      NULL,
      7.387149,
      '2224132',
      35.942961,
      NULL,
      2.001077,
      1,
      NULL,
      2,
      ' 1-15-2001',
      18,
      34,
      1.158531,
      NULL,
      1,
      1.680115,
      0,
      1.924451,
      0,
      0,
      0,
      1,
      0.949161,
      0,
      3,
      0.828401,
      1.434626,
      1.903079,
      1,
      1,
      3.941037,
      1.172001,
      0,
      NULL,
      NULL,
      0,
      5,
      1,
      NULL,
      NULL,
      1.136747,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.937368,
      6.635349,
      3,
      1.628254,
      0.130662,
      0.926956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.582538,
      1,
      2.989928,
      3,
      NULL,
      0.285238,
      1,
      NULL,
      0,
      0,
      0,
      1.082028,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      4,
      1,
      1,
      0,
      0.637073,
      0.238448,
      1.656050,
      1.600792,
      1,
      0.814138,
      1.622975,
      1,
      0,
      0,
      NULL,
      0.531510,
      0.429870,
      0.569388,
      NULL,
      NULL,
      5,
      0.566109,
      NULL,
      0,
      0,
      7.754939,
      0,
      2,
      NULL,
      3,
      0.939576,
      0.210186,
      1,
      3.122781,
      NULL,
      0.792043,
      4.456044,
      1,
      3,
      NULL,
      7.522200,
      4,
      8,
      9,
      3.400387,
      NULL,
      2.957722,
      1,
      NULL,
      NULL,
      0.818265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      0.713814,
      0.884390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.960823,
      NULL,
      NULL,
      NULL,
      NULL,
      1.646912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0.503033,
      0.725740,
      3,
      NULL,
      1,
      1.860169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.543838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2.110570,
      0.811405,
      1,
      2.812237,
      0,
      1.255763,
      1,
      2,
      0.755622,
      NULL,
      1,
      0.683392,
      1.194394,
      NULL,
      1,
      1,
      0.998360,
      1.831935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.209718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '20400',
      '',
      '',
      0.098281,
      NULL,
      NULL,
      '',
      0,
      '0230',
      '',
      NULL,
      4.464671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


