set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33',
      16,
      2.158899,
      '0324110',
      6,
      2,
      NULL,
      1,
      '404401',
      3.111687,
      ' 6-17-1976',
      41.998572,
      110,
      0.075989,
      NULL,
      2.337972,
      1,
      NULL,
      1.553051,
      3.621964,
      0.018156,
      1.935020,
      0.861351,
      NULL,
      1,
      3,
      1.766846,
      0,
      0,
      NULL,
      0,
      1.025397,
      0.196004,
      1,
      1.202331,
      0.283943,
      0.346152,
      1,
      0,
      4,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.965874,
      NULL,
      NULL,
      5,
      0.562503,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.019781,
      3.863190,
      0,
      0,
      NULL,
      1.287343,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.770287,
      NULL,
      5,
      3.227424,
      0.045440,
      NULL,
      1.799430,
      1,
      1.461303,
      1,
      0.211691,
      0.011901,
      0.896989,
      0.848556,
      0.127054,
      1,
      1,
      1.608688,
      1.204592,
      NULL,
      NULL,
      4,
      0.835573,
      1,
      0.428627,
      NULL,
      2,
      0.671654,
      0,
      1,
      1,
      1,
      1.646732,
      1,
      NULL,
      NULL,
      0.396794,
      NULL,
      1.011270,
      4.620902,
      8.219245,
      7.085807,
      3.741569,
      9.679690,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      8.598815,
      0.267458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0.223430,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.769612,
      NULL,
      NULL,
      NULL,
      NULL,
      0.446170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      5,
      0.413903,
      0,
      1,
      3.160022,
      NULL,
      0.224016,
      NULL,
      NULL,
      NULL,
      1.766719,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.000185,
      3.682689,
      NULL,
      1.719926,
      0,
      0,
      2,
      NULL,
      NULL,
      0.908546,
      1,
      0.698814,
      0,
      1.177633,
      1.162702,
      0,
      0.251321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '00041',
      '',
      '',
      3.324079,
      '04343',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


