set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '133',
      '21330242',
      51.623387,
      1,
      '0321041',
      130,
      1,
      1,
      3,
      NULL,
      NULL,
      '10-18-1989',
      6.093550,
      25.300621,
      0.195710,
      NULL,
      1,
      2.415528,
      0.966461,
      0,
      3,
      1.283803,
      1,
      1.584440,
      1.208921,
      0.988814,
      3,
      0.473338,
      0.631521,
      1,
      0,
      1.977819,
      0.880519,
      0,
      1,
      1,
      1.302774,
      1.458100,
      NULL,
      1,
      NULL,
      1.561143,
      2.135924,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.086378,
      1.140152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.868045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0.787014,
      1.869926,
      NULL,
      0.057312,
      1,
      1.141488,
      0.381701,
      1,
      0,
      1.540830,
      1,
      1.016964,
      0.452907,
      1,
      1,
      NULL,
      1.469732,
      2,
      3,
      0.305591,
      4,
      0,
      1,
      1.887223,
      4,
      0,
      1.566052,
      1,
      5.298390,
      1,
      NULL,
      1,
      NULL,
      NULL,
      4.742737,
      4.245327,
      4.771924,
      5,
      6.098250,
      2,
      NULL,
      NULL,
      0.977372,
      NULL,
      1.717391,
      NULL,
      NULL,
      NULL,
      0.123723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.663646,
      1,
      1,
      0,
      1.132583,
      0.826663,
      0.053929,
      1.637117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.304153,
      0,
      1.478251,
      NULL,
      3.281113,
      NULL,
      3.675206,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.280954,
      1.822037,
      NULL,
      1,
      1.959098,
      NULL,
      NULL,
      NULL,
      1.416945,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531976,
      NULL,
      1.528068,
      0,
      1,
      NULL,
      2,
      0.580669,
      2.677499,
      2.839637,
      1.309289,
      NULL,
      NULL,
      NULL,
      0.776093,
      1,
      0,
      1.464600,
      1.563617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '',
      '',
      1.932741,
      '44230',
      '',
      '',
      NULL,
      '',
      '',
      '',
      4,
      NULL,
      NULL,
      3.719888,
      0,
      NULL,
      NULL,
      NULL,
      0.650438);
commit;
end;
/


