set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '433',
      NULL,
      40,
      18.316643,
      NULL,
      NULL,
      0,
      1.248804,
      0,
      '401301',
      NULL,
      ' 0-25-1979',
      16.046315,
      8,
      NULL,
      NULL,
      3,
      NULL,
      0.589225,
      1.878830,
      3,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.299988,
      NULL,
      0.209194,
      1.650501,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      1,
      1.619644,
      NULL,
      1,
      NULL,
      NULL,
      0.957772,
      0.746596,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.326820,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.679066,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.381183,
      3.768169,
      3.443982,
      1.593624,
      1,
      0,
      0,
      0.609483,
      NULL,
      1.806781,
      0,
      1,
      1,
      NULL,
      1,
      0.130676,
      1,
      NULL,
      1.893398,
      3.395962,
      0.857222,
      1.850542,
      5.613365,
      0.388924,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      0,
      1,
      NULL,
      2,
      0.697259,
      2,
      6.849445,
      NULL,
      7.287750,
      3.147870,
      8.870217,
      7,
      0.018646,
      1.210827,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.167134,
      1.725363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.880006,
      NULL,
      NULL,
      NULL,
      NULL,
      7.242932,
      0.049223,
      NULL,
      0,
      1.724230,
      NULL,
      2,
      2.283668,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1.519045,
      2,
      0.324756,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.720622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      2.069579,
      0.569077,
      2,
      1.338418,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      1.418663,
      0,
      1.853886,
      0.514853,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.696714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.124419,
      '43023',
      NULL,
      '',
      NULL,
      '24413',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      5,
      1,
      2,
      NULL,
      3,
      1.671004,
      3.208979,
      0,
      1.625873);
commit;
end;
/


