set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      41.241744,
      28,
      '2132414',
      48.865154,
      2,
      1.692204,
      2,
      '121410',
      1,
      ' 7-18-1982',
      10,
      NULL,
      1.516893,
      NULL,
      2.989069,
      NULL,
      2,
      1.853072,
      0.985313,
      1,
      0.328318,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      1.892637,
      0.487208,
      NULL,
      2.313199,
      1.990954,
      NULL,
      0,
      1.626949,
      0,
      1.678273,
      1,
      3.964114,
      0.376097,
      1.050342,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.706050,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.215626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      4.767014,
      NULL,
      0,
      0,
      0,
      0.564618,
      1,
      0,
      1.271793,
      NULL,
      0.024238,
      1,
      1,
      0,
      1,
      0.477603,
      NULL,
      0,
      3,
      4,
      1.559622,
      2,
      0.292510,
      4.116803,
      0.013823,
      NULL,
      1.769926,
      1.502660,
      1.600340,
      2.397457,
      4.168702,
      3,
      1,
      0.019119,
      3,
      3,
      7.996325,
      4.079675,
      7.746822,
      NULL,
      11,
      8.063170,
      1.122959,
      2.619569,
      0,
      1,
      NULL,
      NULL,
      2.043376,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.183088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.485967,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.994025,
      2.085070,
      1,
      1,
      3,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.440506,
      1,
      NULL,
      0.119458,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      4.375314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.714500,
      2.110028,
      1.284043,
      1.811091,
      1,
      2.462670,
      NULL,
      3.244816,
      NULL,
      3,
      0,
      NULL,
      1,
      1.359890,
      0.258151,
      0,
      1.932250,
      0,
      NULL,
      1.855126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.412053,
      '13010',
      '',
      '',
      NULL,
      '24001',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      0,
      2,
      0.894464,
      2.393171,
      NULL,
      1,
      0.306460,
      2.941366);
commit;
end;
/


