set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '303',
      NULL,
      2.487482,
      3.324981,
      '3014234',
      85,
      3,
      0.870369,
      NULL,
      '224200',
      NULL,
      '10-24-1994',
      2.168014,
      24,
      NULL,
      NULL,
      2,
      0.837360,
      NULL,
      1.333269,
      0.437329,
      NULL,
      3.839206,
      NULL,
      0,
      1.261809,
      5,
      1,
      1.364237,
      0,
      NULL,
      0,
      NULL,
      1.146255,
      NULL,
      1,
      1,
      1.185970,
      2.982330,
      1,
      0,
      1.807919,
      0,
      1,
      NULL,
      NULL,
      1.147474,
      NULL,
      NULL,
      NULL,
      0.639811,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.250869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.524972,
      3,
      1.145530,
      1.895410,
      1,
      1.992780,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      0,
      1.531730,
      NULL,
      1,
      2,
      0.406421,
      0.508913,
      2,
      NULL,
      6,
      0,
      NULL,
      1,
      1.322715,
      NULL,
      2.745994,
      3.102956,
      0,
      1,
      0.682941,
      4,
      0,
      7.511318,
      5,
      7,
      1,
      NULL,
      3,
      0.617538,
      0,
      0.908511,
      0,
      NULL,
      NULL,
      7.515522,
      0.041398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.746820,
      0.783553,
      0,
      NULL,
      1.596212,
      1.494794,
      NULL,
      0.349508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.020257,
      0.588630,
      1,
      0,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.730509,
      NULL,
      0,
      4,
      0.417048,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.030908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      NULL,
      2,
      0,
      3.365488,
      3.954352,
      0.855258,
      0,
      1.581240,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      1.032698,
      NULL,
      0.528622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.256734,
      '02102',
      '',
      '',
      3.545508,
      '03104',
      '',
      '',
      0.045272,
      '',
      '',
      '',
      1,
      3,
      0.823682,
      3.025674,
      3.188620,
      NULL,
      1,
      3.794653,
      3.473813);
commit;
end;
/


