set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20314420',
      29,
      34,
      '4433402',
      192,
      5,
      3.293070,
      1,
      '402333',
      4.198452,
      ' 3-10-1974',
      29,
      35,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      3.553727,
      0.775717,
      3,
      0.218104,
      1.661572,
      1,
      2.632288,
      0,
      1.130915,
      0.705049,
      0.010340,
      0.984906,
      3,
      0.535573,
      NULL,
      0,
      0,
      1.224208,
      3,
      0,
      1.058596,
      1,
      2.984798,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.780607,
      1.532298,
      0.615975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.848906,
      1.842443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.881020,
      2.323434,
      3,
      1,
      1,
      1,
      0.542693,
      1,
      0,
      0.916305,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.424030,
      NULL,
      0.270637,
      4.807554,
      1,
      0.657153,
      2.969001,
      0.669276,
      3.298388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.622632,
      NULL,
      6.163451,
      1,
      1.462801,
      6.978134,
      4,
      2.296054,
      0.398953,
      6.063019,
      NULL,
      NULL,
      4.282371,
      1,
      NULL,
      3.699009,
      0,
      NULL,
      NULL,
      4.369186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.736670,
      1,
      0,
      NULL,
      0,
      1.577213,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.999796,
      NULL,
      NULL,
      NULL,
      NULL,
      1.502969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      0.742536,
      1,
      1.107856,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.928978,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.449000,
      1,
      1.701866,
      1.593429,
      1,
      2.028742,
      0.267534,
      3,
      1,
      0,
      0,
      0.436531,
      0,
      0.285963,
      1,
      NULL,
      0.561350,
      0,
      0.168172,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '00314',
      '',
      '',
      0.694640,
      '13011',
      '',
      '',
      0.120055,
      '',
      '',
      '',
      4,
      2.042472,
      NULL,
      3,
      1.953129,
      0.158537,
      2.479634,
      1.911103,
      0.658515);
commit;
end;
/


