set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1223',
      '40133113',
      NULL,
      28.677481,
      '2023224',
      28.667616,
      3,
      1,
      0,
      '422242',
      4.022992,
      '11-27-1989',
      33.559018,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.990152,
      1.599451,
      3.801324,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.104034,
      1.393295,
      1.122075,
      1.845036,
      NULL,
      1.009206,
      4,
      NULL,
      0.242113,
      NULL,
      1.298006,
      0.982996,
      NULL,
      1,
      NULL,
      3.068295,
      0.725121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.920551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.925870,
      NULL,
      0.672971,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.646976,
      5.662655,
      0,
      1,
      NULL,
      1.081014,
      1.037137,
      NULL,
      0.331085,
      0,
      0,
      1.399599,
      0,
      0,
      1.121821,
      0.069039,
      NULL,
      NULL,
      0,
      1.706215,
      1.003097,
      6,
      1.477531,
      1,
      1,
      NULL,
      5.790917,
      NULL,
      NULL,
      1,
      1.698170,
      4.131561,
      NULL,
      0.709078,
      7,
      4,
      6.651707,
      1.897532,
      4.595658,
      6,
      NULL,
      5,
      NULL,
      3.577917,
      NULL,
      1,
      1.099537,
      0,
      2,
      0.249033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.258128,
      0,
      0,
      0,
      1,
      0.209190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.486648,
      NULL,
      NULL,
      NULL,
      NULL,
      1.334265,
      0,
      NULL,
      0.834017,
      0,
      0,
      5.628630,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.581704,
      0.264132,
      0.896807,
      0.043338,
      1,
      1,
      0.112099,
      NULL,
      NULL,
      NULL,
      1.404391,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.405838,
      1.966466,
      0.405534,
      2,
      1,
      0,
      0.471316,
      1.320800,
      1.390011,
      1.836390,
      NULL,
      0.609136,
      NULL,
      0.450272,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '00114',
      '',
      '',
      3,
      '01130',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      2,
      3,
      NULL,
      3,
      NULL,
      NULL,
      1.656072,
      NULL);
commit;
end;
/


