set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4424',
      '30000424',
      12.603089,
      80.108720,
      NULL,
      NULL,
      2,
      1,
      2,
      NULL,
      3.844820,
      ' 5-16-1984',
      NULL,
      5.000044,
      1.465446,
      NULL,
      2.624007,
      0,
      1.600531,
      1.222464,
      1.419715,
      0.836892,
      1.797920,
      0,
      1.494350,
      NULL,
      1.877477,
      NULL,
      0.950050,
      1,
      0.015953,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.574938,
      1.808533,
      NULL,
      NULL,
      4,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.050441,
      1.285631,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.150481,
      1.043947,
      0.133649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.426486,
      2.466935,
      5,
      5.435048,
      0.178176,
      NULL,
      1,
      NULL,
      0,
      0,
      0.518005,
      1.031014,
      1,
      0.032793,
      1.146563,
      0.452729,
      0,
      0,
      NULL,
      NULL,
      0,
      3.351705,
      1.974896,
      0,
      3,
      0.804043,
      1.896062,
      0.032307,
      3,
      0.216308,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.437996,
      5.357143,
      2.996802,
      7,
      7.351233,
      1,
      NULL,
      11,
      2,
      1,
      6.515871,
      2.130767,
      3.933934,
      1.521163,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.908665,
      1.891681,
      1,
      0,
      NULL,
      0,
      NULL,
      1.252506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.698288,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.011622,
      3,
      1,
      1,
      3,
      3,
      1.170570,
      1.284195,
      NULL,
      NULL,
      NULL,
      4.757134,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.169533,
      NULL,
      NULL,
      NULL,
      1.351520,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      NULL,
      0,
      3.601721,
      3,
      0.951625,
      3.140675,
      0,
      NULL,
      NULL,
      1,
      0.197627,
      NULL,
      1.646151,
      1.718559,
      0.653692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.258304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '31401',
      '',
      '',
      3,
      '44111',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      3,
      3.110970,
      0,
      NULL,
      0,
      3.315724,
      2.520800,
      NULL,
      1.748719);
commit;
end;
/


