set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9203746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0021',
      NULL,
      50.357828,
      31,
      NULL,
      210,
      0,
      0.267698,
      NULL,
      '340441',
      5,
      ' 4-15-1978',
      23,
      8,
      NULL,
      NULL,
      1,
      1.503155,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      1.530968,
      0.775788,
      5,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0.466616,
      0.114276,
      0.493165,
      0,
      1,
      3,
      0.587351,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      1.402545,
      0.919313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.079143,
      2,
      2.596073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      6.248211,
      0,
      0.326812,
      NULL,
      NULL,
      0,
      1.987127,
      1,
      0,
      0,
      1.614815,
      0,
      0.707563,
      0.251464,
      1.311570,
      1,
      NULL,
      1.446956,
      7.360093,
      0,
      5,
      3,
      NULL,
      0.140606,
      0.428546,
      1.828005,
      0.531343,
      4.548036,
      0,
      4.794377,
      NULL,
      3,
      0.322809,
      0.189485,
      NULL,
      0.004761,
      3,
      4.472898,
      NULL,
      NULL,
      10.944441,
      8,
      0,
      3.203705,
      1.236877,
      NULL,
      1,
      0,
      8,
      0.905909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.776024,
      0.402612,
      0,
      0.608620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.783055,
      NULL,
      NULL,
      NULL,
      NULL,
      6.072258,
      3,
      3,
      0,
      0.120296,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.485559,
      NULL,
      1.809303,
      5,
      0,
      0,
      0.348550,
      NULL,
      NULL,
      NULL,
      1.944979,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.435972,
      2.935879,
      2.376877,
      3.929780,
      3.823784,
      3,
      3.282568,
      0.017139,
      NULL,
      0.389910,
      1,
      1,
      NULL,
      0,
      1,
      0.211515,
      0.634408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.496152,
      '30333',
      '',
      '',
      3.044128,
      '32423',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      0,
      0.358947,
      NULL,
      2.429776,
      0.896233,
      3.891203,
      2.031093,
      0.738075);
commit;
end;
/


