set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8328397';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '002',
      '41',
      18.379902,
      8,
      '4042213',
      13.849119,
      NULL,
      NULL,
      0,
      '031011',
      NULL,
      ' 3-25-1976',
      NULL,
      37.610282,
      1,
      NULL,
      0,
      0,
      1.963886,
      NULL,
      NULL,
      1.986858,
      1.109376,
      NULL,
      1.964051,
      0,
      0,
      1,
      1.420893,
      1.874133,
      0,
      0.087061,
      5.265815,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.597123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.603865,
      0.059229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.254879,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.503640,
      NULL,
      0,
      NULL,
      0.653909,
      1.841527,
      1,
      0.516530,
      1.118172,
      0,
      1,
      0,
      0.729171,
      0,
      0.227204,
      1.924752,
      NULL,
      NULL,
      NULL,
      0.561782,
      0.500194,
      5,
      0,
      7,
      NULL,
      NULL,
      2.507985,
      2.409194,
      2.107315,
      2,
      5,
      7,
      1,
      NULL,
      4,
      0.443080,
      5.571676,
      3.692451,
      1,
      0,
      1.798823,
      3.093387,
      1,
      4,
      0.764411,
      1.379485,
      NULL,
      NULL,
      5.275384,
      0.236572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1.370737,
      0,
      0.741713,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.598072,
      NULL,
      NULL,
      NULL,
      NULL,
      1.566787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.692446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.466332,
      2.310178,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.095089,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023227,
      1.593424,
      0.263296,
      1,
      0.538004,
      1.015420,
      3,
      0.578065,
      0,
      1,
      0.887653,
      1.096250,
      0,
      NULL,
      1.067086,
      1.568062,
      0,
      1,
      0.261204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.525149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.051552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.046498,
      NULL,
      NULL,
      NULL,
      NULL,
      0.437899,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.763156,
      2,
      3,
      3.108342,
      1,
      NULL,
      2,
      NULL,
      '3212',
      '44011',
      '02441',
      2,
      '44442',
      '',
      '',
      1,
      '',
      '',
      '',
      3.558144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


