set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8328397';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '013',
      '03',
      37.909551,
      12,
      '4010324',
      60,
      NULL,
      1,
      0,
      '001343',
      NULL,
      ' 5- 5-1999',
      2.605003,
      28.927213,
      1.782935,
      NULL,
      2,
      1.920353,
      0,
      1,
      0,
      0,
      0.117235,
      1,
      0.311298,
      NULL,
      0,
      1,
      0,
      1.030869,
      1.839087,
      1.534490,
      2.325344,
      1.179100,
      1.984814,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.430810,
      0.255046,
      1.027823,
      1.482148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.939030,
      0.954216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490027,
      0,
      1,
      1,
      0,
      1,
      1.262182,
      1,
      1,
      0,
      1.384266,
      1,
      NULL,
      0,
      0,
      0.810683,
      NULL,
      NULL,
      0,
      NULL,
      0.532474,
      0,
      0.785745,
      0.004206,
      3,
      0.587436,
      7,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5,
      NULL,
      0.480034,
      4,
      5,
      3.794189,
      1.908159,
      NULL,
      1,
      0.021097,
      3.851045,
      2.987266,
      0,
      1,
      1,
      NULL,
      NULL,
      7.330460,
      1.566094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.690915,
      0.500413,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.781963,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5.481330,
      4,
      1,
      1.189423,
      0.171979,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.787356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.472819,
      1.334581,
      NULL,
      0.392566,
      0,
      3.506924,
      1.385232,
      1.993010,
      0.790676,
      0.456766,
      NULL,
      1,
      1,
      1.869783,
      1,
      1,
      1.698152,
      0,
      NULL,
      0.934130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.596734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.658804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.499885,
      NULL,
      NULL,
      NULL,
      NULL,
      0.513089,
      NULL,
      NULL,
      NULL,
      NULL,
      2.381091,
      NULL,
      0,
      5,
      NULL,
      1,
      1.675006,
      2,
      5,
      '1320',
      NULL,
      '21114',
      2.045949,
      '42314',
      '',
      '',
      0.652295,
      '',
      '',
      NULL,
      4.311603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


