set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8328397';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '443',
      NULL,
      13,
      22.294996,
      '0014110',
      71.477852,
      5,
      2.100746,
      NULL,
      '413240',
      2,
      ' 9-21-1997',
      19.774195,
      16.117965,
      1.560718,
      NULL,
      0.603389,
      NULL,
      NULL,
      0,
      0.563972,
      1,
      0.712655,
      1,
      1,
      0,
      1.650712,
      0,
      1,
      NULL,
      1,
      NULL,
      4,
      0.693689,
      1,
      1.513090,
      1.827023,
      1.512236,
      2.459396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.369810,
      1.047716,
      1.648380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.577865,
      0.781012,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.259737,
      1,
      1,
      1.487528,
      2.109567,
      1,
      0.468635,
      1.577144,
      1,
      0,
      0.261176,
      1.927253,
      NULL,
      0,
      0.962943,
      1,
      1,
      1,
      1.638835,
      NULL,
      1.913304,
      5.998114,
      0,
      0,
      1.957988,
      1,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      1.532449,
      NULL,
      1,
      NULL,
      3.464787,
      NULL,
      0.250707,
      0.553396,
      NULL,
      2.663755,
      3,
      0,
      3.090815,
      0.540990,
      NULL,
      NULL,
      1.347719,
      0.898025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335550,
      NULL,
      0,
      0,
      1,
      NULL,
      0.596528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.850221,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.531191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.875037,
      0,
      1.888772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.525342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.078755,
      NULL,
      0.423151,
      0.082284,
      2,
      1,
      0.974741,
      1,
      NULL,
      1.123355,
      NULL,
      0,
      1.283443,
      1.600190,
      1,
      0,
      0,
      1.882482,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.431557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712909,
      NULL,
      NULL,
      NULL,
      NULL,
      1.896534,
      NULL,
      NULL,
      NULL,
      NULL,
      0.421636,
      1.542720,
      3,
      NULL,
      NULL,
      1.289505,
      0,
      0,
      6.062056,
      '3132',
      '14020',
      '01102',
      0.443071,
      '31300',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3,
      3.804874,
      3.196496,
      6,
      1,
      NULL,
      NULL,
      3.946276,
      0.387145);
commit;
end;
/


