set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8328397';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '434',
      '40130302',
      52.051149,
      59,
      '3044143',
      55.085989,
      2,
      2.775801,
      2,
      '000241',
      1.830196,
      ' 7-24-1996',
      14,
      42.747298,
      0,
      NULL,
      3.231075,
      0.958864,
      3,
      0,
      0.283790,
      2.316090,
      1.573816,
      1,
      1.726711,
      0.157069,
      1.410150,
      1.981944,
      0,
      NULL,
      1,
      NULL,
      0,
      0.462461,
      NULL,
      0.308204,
      0.773114,
      1.391906,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.492128,
      1.563689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.802881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.928155,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0.727787,
      1.312075,
      1,
      1.600154,
      0,
      1,
      NULL,
      0.479182,
      0.729945,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0.498052,
      5,
      1.989366,
      3,
      5,
      4.008543,
      7.080107,
      1.718745,
      0,
      4,
      NULL,
      0.078786,
      1,
      5,
      NULL,
      3.882925,
      0.794398,
      1,
      0,
      0,
      1.481958,
      1,
      NULL,
      0.528423,
      NULL,
      NULL,
      9.013299,
      0.759619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.087444,
      1,
      0,
      0,
      0.570188,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.116149,
      NULL,
      NULL,
      NULL,
      NULL,
      1.923973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.710155,
      0.660519,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.632564,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399216,
      1.923481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.563939,
      NULL,
      0.951400,
      0.938009,
      0.196430,
      3.743402,
      NULL,
      1.775628,
      1,
      2.904862,
      0.930296,
      0.441636,
      0,
      1.885405,
      1,
      1.132344,
      1.026136,
      NULL,
      1,
      1.886318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.461344,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2.793916,
      9,
      2.057297,
      1,
      1,
      2,
      0,
      '2124',
      '13234',
      '00042',
      1.550809,
      '33012',
      '',
      '',
      0.724596,
      '',
      NULL,
      '',
      3.270267,
      2.796058,
      NULL,
      3.841167,
      2,
      3,
      2.221675,
      1,
      1);
commit;
end;
/


