set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8328397';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '402',
      '43041324',
      1.379936,
      66.055227,
      NULL,
      39,
      1,
      3.507552,
      2,
      '013001',
      5,
      ' 2-24-1987',
      25.659189,
      3,
      NULL,
      NULL,
      0.174454,
      NULL,
      3.211027,
      0,
      1.097983,
      0,
      0.944506,
      0,
      0,
      1,
      1,
      0,
      1.514853,
      NULL,
      1.380403,
      0.326766,
      0.370444,
      NULL,
      0.996761,
      1,
      NULL,
      1,
      0.139186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389896,
      1.092382,
      1.306127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.153497,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      1.922762,
      0,
      0,
      0,
      0,
      1.725615,
      1.242045,
      NULL,
      1,
      0.001323,
      0.170398,
      NULL,
      0.283194,
      1,
      NULL,
      0.716812,
      1.230778,
      0.629897,
      4,
      3.359340,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      0.922311,
      0,
      3,
      NULL,
      NULL,
      0.462536,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.834546,
      NULL,
      0,
      1,
      0.061638,
      0.931438,
      1.889116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.497526,
      NULL,
      NULL,
      NULL,
      NULL,
      1.889543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.576904,
      3.820106,
      1,
      NULL,
      NULL,
      NULL,
      4,
      4,
      3.557986,
      0.767285,
      1.215526,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.474740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.145834,
      1,
      2,
      NULL,
      NULL,
      3,
      1,
      2.424925,
      0.298889,
      1,
      NULL,
      0.291273,
      0.199289,
      1,
      1.348181,
      NULL,
      0,
      1,
      2.465261,
      0.041662,
      0.872099,
      NULL,
      2.269382,
      1,
      3,
      0,
      0.273671,
      1.334527,
      NULL,
      0,
      0,
      0,
      0,
      1.926055,
      3.897535,
      1,
      0.939246,
      1,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      8.188968,
      3,
      1.110740,
      1,
      2,
      5,
      '2201',
      NULL,
      NULL,
      1.731409,
      NULL,
      NULL,
      '',
      1.533229,
      '',
      NULL,
      '',
      4.860288,
      NULL,
      NULL,
      6,
      3,
      NULL,
      NULL,
      2.123922,
      1);
commit;
end;
/


