set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8328397';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      55,
      67,
      '0401040',
      NULL,
      6,
      1,
      3,
      NULL,
      NULL,
      ' 3-25-1987',
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.394586,
      2,
      1.403804,
      0.459388,
      1.897443,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.359160,
      0,
      0.673061,
      0.280453,
      0,
      NULL,
      NULL,
      1.446084,
      1,
      0.761087,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.596536,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531456,
      0.631477,
      0.367289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.506458,
      3.816065,
      1.125095,
      0.511697,
      1.221024,
      1,
      0,
      1.716784,
      0,
      NULL,
      1.872165,
      NULL,
      0.958396,
      0.840416,
      1,
      0,
      NULL,
      0.761174,
      NULL,
      NULL,
      0.716140,
      0,
      NULL,
      5.700134,
      1.508145,
      0,
      0,
      4,
      6,
      3,
      10,
      7,
      NULL,
      1.051925,
      5,
      4,
      3,
      2,
      0.903291,
      1.380943,
      0.128402,
      3.755398,
      3.991908,
      1,
      4,
      0.688936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.172643,
      1,
      1,
      1.366598,
      NULL,
      0.671633,
      1.477057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.010446,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.057182,
      1.357600,
      0,
      NULL,
      NULL,
      NULL,
      0.698055,
      4,
      3,
      1.192669,
      0.084630,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.705895,
      2.122918,
      0.535949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.471767,
      0,
      NULL,
      1.945800,
      1,
      1.077034,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      1.692162,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1.706005,
      3.398380,
      NULL,
      3.935834,
      1.464689,
      0,
      1,
      0.517854,
      0,
      0,
      1,
      0,
      1.433808,
      0.029417,
      0,
      1,
      1,
      0.736362,
      0,
      0.672622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.348521,
      1,
      2,
      6.118036,
      0,
      0,
      0.631715,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.672580,
      '44021',
      '',
      '',
      0.952204,
      '',
      '',
      NULL,
      4.837334,
      NULL,
      NULL,
      5.095073,
      3,
      NULL,
      0.993784,
      3.760711,
      3);
commit;
end;
/


