set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8328397';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1304',
      NULL,
      10.847207,
      14.068327,
      '3020123',
      NULL,
      6,
      NULL,
      3,
      '444044',
      5,
      NULL,
      56.569277,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.101718,
      0,
      1.915051,
      NULL,
      1.068914,
      0,
      0.739692,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.151938,
      1,
      NULL,
      0,
      0.734836,
      NULL,
      0,
      NULL,
      4,
      1,
      NULL,
      1.316604,
      1.141590,
      0.643966,
      NULL,
      NULL,
      0.370605,
      NULL,
      NULL,
      1.703946,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.496934,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      0.415320,
      5.554015,
      NULL,
      1,
      0.383487,
      1,
      0,
      0.532898,
      NULL,
      0.036239,
      1,
      0.791020,
      1,
      0.495363,
      0.928538,
      0,
      NULL,
      1.235348,
      0.584582,
      0.450364,
      1.836125,
      1,
      NULL,
      3.276675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.296962,
      1.930568,
      1.119403,
      NULL,
      1.792734,
      0,
      4.333293,
      NULL,
      NULL,
      0.719950,
      1,
      NULL,
      0,
      1,
      1,
      2.238054,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1.206480,
      1.103732,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.417305,
      NULL,
      NULL,
      NULL,
      NULL,
      5.525840,
      1.594816,
      0.488475,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.675212,
      1.777952,
      0.367973,
      0,
      0.973869,
      NULL,
      NULL,
      NULL,
      1.332611,
      0,
      0.600640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.749051,
      0,
      NULL,
      1,
      1,
      1,
      0.375428,
      1.761522,
      0,
      1.299969,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.205265,
      1.627313,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.557700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012870,
      NULL,
      NULL,
      NULL,
      NULL,
      1.494767,
      NULL,
      NULL,
      NULL,
      NULL,
      0.608119,
      1.616571,
      0,
      NULL,
      NULL,
      1.193324,
      1.252935,
      0,
      NULL,
      '0003',
      '44121',
      '20210',
      2,
      '31433',
      '',
      '',
      1.487439,
      '',
      '',
      NULL,
      NULL,
      7,
      1,
      2,
      0,
      1.152098,
      NULL,
      3.081062,
      3.218684);
commit;
end;
/


