set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8328397';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4021',
      '13024034',
      31.919449,
      80.861966,
      '1410021',
      8.436601,
      0,
      3,
      NULL,
      '301000',
      3,
      ' 1-20-1974',
      NULL,
      37.468982,
      NULL,
      NULL,
      1.833805,
      0,
      2.124070,
      0.513590,
      1,
      1,
      1,
      NULL,
      0,
      0,
      2.612349,
      1,
      0.440067,
      1.597236,
      1.684107,
      0,
      NULL,
      0.379256,
      0,
      NULL,
      0.603398,
      0.049230,
      3.135603,
      NULL,
      2.007202,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.783637,
      1,
      1.300995,
      1.277175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651847,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.866615,
      0.863823,
      1,
      NULL,
      1,
      NULL,
      0,
      0.169362,
      0,
      NULL,
      1.632238,
      1.594836,
      1,
      NULL,
      1,
      0.471093,
      1.905379,
      0.470550,
      NULL,
      1,
      3,
      0,
      1.458811,
      0.115499,
      0,
      2,
      3.746745,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.645003,
      4,
      NULL,
      0,
      1.674403,
      NULL,
      4.195894,
      NULL,
      0.004759,
      1.972993,
      0.969315,
      1,
      0,
      NULL,
      5,
      0.984820,
      NULL,
      NULL,
      0.185500,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.605224,
      1,
      NULL,
      0,
      0,
      1.937490,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.228511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.494678,
      0.829254,
      1.317925,
      1.812930,
      0,
      0.493135,
      NULL,
      NULL,
      NULL,
      1.423037,
      0.686964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      3,
      2.546831,
      0.241229,
      1.606833,
      0.962507,
      0,
      0,
      NULL,
      NULL,
      0.755594,
      0,
      1,
      1.890408,
      0.393052,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.530834,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.395397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.898679,
      NULL,
      NULL,
      NULL,
      NULL,
      0.195902,
      1.090118,
      NULL,
      NULL,
      0.277515,
      0,
      NULL,
      2,
      NULL,
      '3022',
      '14323',
      '04432',
      3,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      5.943910,
      NULL,
      1,
      1,
      0.954453,
      2,
      0.974971,
      1.481161,
      4);
commit;
end;
/


