set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9406400';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '000',
      NULL,
      NULL,
      41,
      '0423404',
      27,
      NULL,
      NULL,
      NULL,
      '402423',
      4,
      ' 1-15-1981',
      36,
      9,
      NULL,
      NULL,
      0,
      1.137397,
      NULL,
      NULL,
      NULL,
      1.423703,
      0.395276,
      0,
      1,
      1.359679,
      0.600511,
      0,
      1.266800,
      0.379376,
      0.117971,
      1.258958,
      0,
      NULL,
      1.106619,
      0.952989,
      0.609236,
      0,
      0.337202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.388103,
      NULL,
      1.881023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165182,
      1.849900,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1.578325,
      0.309869,
      1,
      NULL,
      0,
      0.980263,
      0,
      NULL,
      1.798382,
      0.731583,
      1.864173,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1.397596,
      0.364326,
      0,
      0.514851,
      NULL,
      NULL,
      NULL,
      NULL,
      0.721421,
      NULL,
      1.338283,
      1,
      NULL,
      1.849084,
      NULL,
      1,
      5.239889,
      2,
      1,
      NULL,
      1.120900,
      0.760933,
      1.214687,
      1.993631,
      0.348930,
      NULL,
      NULL,
      1.721015,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.759444,
      1,
      0,
      NULL,
      1.403308,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.483010,
      NULL,
      5.758653,
      0.254971,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.136432,
      0,
      NULL,
      3.654824,
      0,
      1.939438,
      NULL,
      0,
      6,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      2.894948,
      2.044554,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.652019,
      0.786821,
      0.513081,
      1,
      0.785646,
      NULL,
      0.718367,
      1.391284,
      0,
      0.088878,
      1.341441,
      0,
      0.978815,
      NULL,
      1,
      0,
      0.311754,
      0.659446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.088123,
      '',
      '',
      '',
      NULL,
      1.545031,
      5.053458,
      1,
      2,
      2.139436,
      2,
      2.899091,
      NULL);
commit;
end;
/


