set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-1-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      NULL,
      NULL,
      '2232200',
      13.414772,
      5,
      NULL,
      0,
      NULL,
      2,
      NULL,
      30.035238,
      NULL,
      1.865546,
      NULL,
      2,
      NULL,
      1.923433,
      1.265594,
      0,
      0.202606,
      0,
      1.853929,
      0,
      0.061091,
      7,
      1.863009,
      2,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      0.991913,
      2.270172,
      1,
      2.810768,
      0,
      1.505549,
      1,
      NULL,
      NULL,
      0.524103,
      NULL,
      NULL,
      0.751204,
      0,
      0.269342,
      0.853179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.436910,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.415551,
      3,
      NULL,
      2.250603,
      NULL,
      2.591214,
      1.820626,
      0,
      0,
      0,
      1.902085,
      1.319584,
      0,
      NULL,
      0,
      NULL,
      1.491170,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      5,
      1.953739,
      3.065052,
      0.303482,
      3,
      4,
      3,
      NULL,
      1,
      1,
      3,
      3,
      6.989485,
      5.626915,
      5.096276,
      2.667692,
      1.458834,
      4.163872,
      8.158561,
      1.548089,
      NULL,
      3,
      2,
      0.062884,
      0,
      1.046149,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.967988,
      0,
      NULL,
      1,
      NULL,
      1.875432,
      0.305536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      1.519286,
      1,
      3.915904,
      1,
      0.459654,
      0,
      2,
      5,
      1,
      1.927880,
      NULL,
      NULL,
      NULL,
      5.207853,
      0.049701,
      6,
      NULL,
      0,
      1,
      7,
      0.552770,
      NULL,
      NULL,
      1.365469,
      9,
      0.684119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.704804,
      NULL,
      0,
      1,
      2.250953,
      0,
      NULL,
      3,
      1,
      2.140195,
      1.053041,
      0,
      1.835632,
      0,
      0,
      NULL,
      0,
      0,
      0.888583,
      0.777644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.648270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.360573,
      '00234',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.616263,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


