set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-6-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      '0234420',
      15,
      4,
      3,
      3,
      '331131',
      2,
      ' 0-15-1984',
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.968057,
      0,
      0.621987,
      0.125891,
      NULL,
      0.438599,
      0,
      3,
      NULL,
      0,
      7.603915,
      2.533863,
      1.190287,
      NULL,
      NULL,
      0.753875,
      1.483306,
      1,
      0,
      0.983320,
      0,
      3,
      NULL,
      2.674400,
      1,
      0.714486,
      1.014788,
      NULL,
      NULL,
      1.277065,
      NULL,
      NULL,
      1,
      0,
      1.775515,
      1.652985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.521680,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.509487,
      NULL,
      4.772448,
      0.935123,
      1,
      1,
      0.728732,
      0,
      NULL,
      2,
      NULL,
      1.967648,
      0.189296,
      0.730846,
      1,
      NULL,
      1.594335,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      4.415988,
      1,
      0,
      4,
      NULL,
      1.234152,
      4,
      4.765004,
      1,
      4,
      0,
      5.254195,
      7.167343,
      1.164847,
      NULL,
      4,
      5,
      1,
      0,
      1.485688,
      0.625238,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.944992,
      0.639830,
      0,
      0,
      0,
      1,
      1.601606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.809702,
      3,
      3,
      7.460671,
      1,
      NULL,
      1,
      1.380209,
      4.624992,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.600736,
      NULL,
      NULL,
      0.160454,
      NULL,
      2,
      1,
      1.305224,
      NULL,
      NULL,
      0,
      3.877326,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.373798,
      2.840940,
      1,
      NULL,
      2,
      0.306159,
      0.609970,
      NULL,
      0.362896,
      0,
      NULL,
      0.622758,
      NULL,
      1,
      0,
      0,
      1.448707,
      1,
      1.977677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '02222',
      '',
      NULL,
      1.899704,
      '',
      '',
      '',
      1.763585,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


