set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '432',
      '02',
      23.361528,
      5.739627,
      '3231334',
      12.051195,
      NULL,
      2,
      1,
      '023414',
      2.370920,
      ' 2-21-1978',
      30.071607,
      26,
      0,
      NULL,
      NULL,
      0,
      0.920417,
      0.647098,
      0,
      1.350956,
      1.954275,
      1.783774,
      0.944203,
      1.452494,
      0.751514,
      0,
      1.209241,
      NULL,
      1.810595,
      0.923780,
      1,
      1,
      0.851367,
      0,
      1.645734,
      0,
      3.040067,
      1,
      3.945326,
      0.598951,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.252245,
      1,
      1.319116,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.818320,
      1,
      NULL,
      1.012165,
      0.734165,
      1,
      7,
      1,
      1,
      1,
      0.787567,
      1,
      0.796689,
      0.277328,
      0,
      1.233349,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1.072205,
      1,
      0,
      3.699723,
      0.292999,
      1.265524,
      1.673045,
      0.431928,
      0,
      5.097702,
      NULL,
      NULL,
      5,
      NULL,
      5,
      0.557786,
      1,
      2.403713,
      NULL,
      1,
      5,
      0.120294,
      1.632734,
      NULL,
      NULL,
      NULL,
      9,
      0.159094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.817738,
      0.427728,
      0,
      0,
      1.067130,
      1,
      NULL,
      0.154991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.965718,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      1,
      0.264228,
      3.909531,
      2.071386,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.569916,
      4,
      1.898114,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.462744,
      3,
      0,
      0,
      2.014629,
      1.363051,
      NULL,
      1.850032,
      0,
      2.459037,
      0,
      0.659358,
      1.389201,
      0,
      1,
      0.637079,
      NULL,
      0.354372,
      0.813650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '31110',
      '',
      '',
      0.893535,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


