set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '443',
      '13421001',
      29,
      42,
      '1400223',
      40,
      1,
      1,
      3,
      '402144',
      2.419753,
      ' 8-14-1997',
      54.897970,
      10.717379,
      0,
      NULL,
      1.024302,
      NULL,
      NULL,
      0.410280,
      NULL,
      NULL,
      1,
      0.811165,
      2,
      0.111835,
      4.626323,
      3,
      1.978482,
      0.543339,
      1.256685,
      NULL,
      5.338000,
      1.100777,
      0.157013,
      1.496978,
      NULL,
      NULL,
      0.373855,
      0,
      5,
      NULL,
      0.142721,
      NULL,
      NULL,
      NULL,
      0.018288,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.569157,
      0,
      1.185613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.680750,
      1,
      1.677668,
      3,
      2.996324,
      1,
      0,
      1,
      NULL,
      0,
      0,
      4,
      NULL,
      1,
      NULL,
      1.122664,
      NULL,
      NULL,
      0.552777,
      0.408902,
      0,
      0,
      1.399028,
      1,
      1,
      0,
      3,
      1.661835,
      2.864673,
      2.995268,
      1.440924,
      0.494910,
      0.411033,
      0.153006,
      5,
      0.229936,
      5,
      NULL,
      NULL,
      4,
      2,
      NULL,
      0.583211,
      4,
      1,
      1.813399,
      0.220301,
      NULL,
      NULL,
      4,
      1.001271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.684460,
      0,
      1,
      NULL,
      0.843632,
      0,
      0.930408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.965832,
      NULL,
      0,
      0.865014,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0.567093,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.140513,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.668637,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457132,
      1.521337,
      0.610134,
      1.152305,
      0.984459,
      2,
      1,
      3,
      1,
      0.656293,
      1,
      NULL,
      1.462777,
      NULL,
      NULL,
      0.314858,
      1.602793,
      0,
      1,
      0.386843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.358288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.226066,
      '43430',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.917091,
      '',
      '',
      '',
      4,
      NULL,
      3,
      NULL,
      2.569225,
      0.433399,
      NULL,
      3.431349,
      NULL);
commit;
end;
/


