set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '022',
      '00001320',
      5.438288,
      18,
      '4131313',
      224,
      6,
      0,
      3,
      NULL,
      NULL,
      ' 8-10-1985',
      32.351065,
      64.837511,
      0,
      NULL,
      3,
      0.573860,
      3,
      1.094472,
      0.274824,
      1,
      1.629620,
      0,
      1.877042,
      0,
      4,
      NULL,
      0.602180,
      NULL,
      1.331472,
      2.840395,
      5.325037,
      0.508990,
      0.919046,
      0.997067,
      1.338195,
      0.656105,
      2.531441,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.287959,
      0,
      0.637758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.326231,
      1.009810,
      0,
      0.529549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.322929,
      NULL,
      1.390603,
      5.688966,
      3.482742,
      0.755335,
      0,
      5.202710,
      0,
      NULL,
      0.925049,
      0,
      0.007802,
      0.757315,
      0.453636,
      1.238396,
      1.563864,
      NULL,
      1,
      NULL,
      1,
      1.500828,
      1.754667,
      0.178412,
      1,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      1,
      NULL,
      1.996867,
      NULL,
      0,
      5,
      0,
      NULL,
      2,
      NULL,
      3,
      0,
      1,
      1,
      0,
      1.494394,
      NULL,
      NULL,
      2.833517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920724,
      0,
      1,
      0,
      1,
      NULL,
      0.745449,
      0.961638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.201769,
      2.644938,
      2.583399,
      1,
      NULL,
      2,
      2,
      NULL,
      0.212910,
      NULL,
      NULL,
      NULL,
      NULL,
      0.069047,
      1,
      NULL,
      1.464745,
      NULL,
      0.602978,
      NULL,
      NULL,
      NULL,
      0,
      0.338595,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.861075,
      3.968931,
      3,
      NULL,
      1,
      0,
      2,
      0,
      NULL,
      1.731470,
      1,
      1,
      1,
      1.264585,
      1.261384,
      0.744223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.150406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.003949,
      '41141',
      '',
      '',
      1.417570,
      '',
      NULL,
      '',
      1.352422,
      '4340',
      '',
      '',
      NULL,
      5.298838,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL);
commit;
end;
/


