set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '111',
      '03214034',
      17,
      46.769518,
      '2100003',
      154.706505,
      3,
      NULL,
      NULL,
      '141430',
      5.574923,
      ' 8-18-1995',
      12,
      NULL,
      NULL,
      NULL,
      1.287013,
      NULL,
      0,
      1,
      NULL,
      1,
      0.789690,
      1.309720,
      0.135735,
      0.945072,
      NULL,
      NULL,
      0.869185,
      1,
      NULL,
      2,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      2.003716,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.043283,
      NULL,
      NULL,
      0.947383,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      5.279878,
      0,
      NULL,
      1,
      0.337088,
      1.613010,
      0.261598,
      2,
      NULL,
      0.896940,
      1,
      1,
      NULL,
      NULL,
      0.368973,
      NULL,
      0,
      NULL,
      0.383349,
      0,
      1.294733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      5,
      0,
      1,
      NULL,
      0,
      NULL,
      0.728236,
      NULL,
      NULL,
      5.513018,
      NULL,
      0.441388,
      0,
      2.063668,
      1.707985,
      NULL,
      NULL,
      9.837562,
      0.335408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686826,
      NULL,
      1,
      1,
      NULL,
      1,
      1.500593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1.654197,
      NULL,
      NULL,
      NULL,
      1.765733,
      1,
      5.390006,
      1.336033,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.920197,
      0.840365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.617728,
      2.944729,
      1,
      1.465609,
      3,
      0.679706,
      NULL,
      3.052493,
      0.903242,
      0,
      1.858284,
      0,
      1.752403,
      NULL,
      0.338082,
      NULL,
      0.827823,
      0.000627,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.535991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '43130',
      '',
      '',
      1,
      '',
      '',
      '',
      3.993608,
      NULL,
      '',
      NULL,
      4,
      4,
      0,
      4,
      3.013914,
      0.970073,
      3.326076,
      0.931786,
      5);
commit;
end;
/


