set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4404',
      '21430411',
      57.932283,
      0.426401,
      '4111243',
      84.546902,
      2,
      0.846253,
      1,
      '240332',
      3.164706,
      ' 0-29-1999',
      NULL,
      60.831909,
      1,
      NULL,
      NULL,
      3.069502,
      0.135786,
      1,
      1,
      1.992490,
      0.984527,
      1.411497,
      2.123141,
      0,
      3,
      1.847881,
      1.714592,
      0.764480,
      0.029445,
      4,
      NULL,
      1,
      1.171848,
      NULL,
      1.549016,
      NULL,
      4.987261,
      0,
      0.326699,
      NULL,
      1,
      1.682529,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.236612,
      0.226136,
      0.456371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271995,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.018844,
      1.632734,
      1,
      0.376825,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2.255625,
      0.371531,
      1.861038,
      0,
      NULL,
      NULL,
      NULL,
      0.220284,
      1,
      0.149747,
      NULL,
      1.238587,
      NULL,
      NULL,
      0.264453,
      5,
      0,
      NULL,
      1.087339,
      0.061587,
      0.754581,
      NULL,
      1,
      0,
      0,
      0.341211,
      1.893210,
      1,
      4.456578,
      3.897455,
      2,
      0,
      0,
      0.391946,
      0,
      0,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.157451,
      0.187237,
      1,
      0,
      NULL,
      NULL,
      0,
      0.410163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.215175,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.492232,
      3,
      1.212922,
      NULL,
      NULL,
      NULL,
      3.884629,
      1,
      4.858536,
      3.680536,
      1.671390,
      0,
      1.236470,
      NULL,
      NULL,
      NULL,
      1,
      1.862986,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.461962,
      0.955624,
      0,
      0,
      3,
      2,
      1.548621,
      2.073171,
      1,
      1.893406,
      1.986372,
      0,
      0,
      NULL,
      1,
      1.123652,
      1,
      1.692761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '34020',
      '',
      NULL,
      0.326608,
      '',
      '',
      '',
      3.091190,
      NULL,
      '',
      '',
      NULL,
      NULL,
      3.003104,
      2,
      3.527530,
      0.073568,
      NULL,
      1.613713,
      5);
commit;
end;
/


