set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4323',
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      6,
      0,
      1,
      '321331',
      4,
      ' 0- 3-2002',
      45,
      28.165092,
      1,
      NULL,
      2.729492,
      1,
      NULL,
      0.638478,
      0.589510,
      1,
      1,
      1.280450,
      NULL,
      1.958593,
      NULL,
      0,
      NULL,
      1,
      0.337284,
      4.349105,
      5,
      1.162166,
      0,
      1.711548,
      1.216958,
      0,
      5.391554,
      0,
      3,
      3,
      0,
      1.610786,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      1.457313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365030,
      0.774877,
      1.464839,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.565053,
      NULL,
      0,
      3.598043,
      0.820202,
      3.662403,
      NULL,
      1,
      NULL,
      0,
      5,
      1,
      1.179942,
      0.642054,
      1,
      0.470033,
      NULL,
      1.891354,
      0,
      1.242835,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.618772,
      2,
      NULL,
      1.331875,
      0,
      1.925030,
      3.882879,
      0,
      2.848055,
      4,
      3.628650,
      5,
      NULL,
      4,
      5,
      5.368897,
      0,
      0,
      2.500956,
      3,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0.104817,
      0.385247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.915577,
      3.522971,
      3.681936,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.357849,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.373954,
      NULL,
      0.109363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.552947,
      3,
      0.037117,
      1,
      2,
      0.089846,
      2,
      1,
      NULL,
      3,
      1.363578,
      1,
      1,
      NULL,
      1.932319,
      0.127062,
      0,
      0.008759,
      0.924272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '13213',
      '',
      '',
      1.931378,
      '',
      '',
      '',
      3.600883,
      '03101',
      '',
      '',
      0.550225,
      NULL,
      NULL,
      4,
      1,
      NULL,
      1.334283,
      1.626644,
      4);
commit;
end;
/


