set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714836';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4030',
      '13232234',
      54,
      29.765459,
      '4120123',
      202.378356,
      NULL,
      2,
      0,
      '001042',
      NULL,
      ' 1- 7-2000',
      47.712785,
      NULL,
      0.683005,
      NULL,
      NULL,
      NULL,
      3.625155,
      0,
      1.805952,
      1.904769,
      1,
      NULL,
      NULL,
      1.209504,
      NULL,
      1,
      0,
      1,
      0,
      2,
      NULL,
      0,
      0,
      1.539931,
      0.919510,
      0.699751,
      2.143976,
      NULL,
      0.142208,
      2.444391,
      1.852405,
      0.333049,
      NULL,
      NULL,
      1.935817,
      NULL,
      NULL,
      1,
      1,
      1,
      1.921382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042913,
      1.723117,
      1.326566,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618186,
      NULL,
      0.735896,
      0,
      1,
      0,
      0.651680,
      NULL,
      1.377834,
      NULL,
      0.379364,
      2,
      0,
      0.322578,
      0.003367,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      1.156470,
      0.653999,
      1.558728,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.672484,
      3.842906,
      1.426005,
      NULL,
      1,
      5.177855,
      3.688843,
      1.639096,
      0,
      NULL,
      2,
      3.662578,
      4.522023,
      2,
      0,
      0,
      NULL,
      NULL,
      2.953436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.982968,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.616268,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5.695775,
      2,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.668395,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      3.057953,
      1.619951,
      1.204083,
      1,
      0,
      3.436340,
      0.283801,
      1,
      NULL,
      0.618571,
      0,
      0,
      1.189821,
      NULL,
      0,
      0.107729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '10130',
      '',
      '',
      0,
      '',
      '',
      '',
      2.389568,
      NULL,
      NULL,
      '',
      4.326504,
      5,
      3,
      NULL,
      2,
      NULL,
      NULL,
      1,
      2);
commit;
end;
/


