set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127031';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      NULL,
      NULL,
      '2132000',
      NULL,
      NULL,
      NULL,
      2,
      '144324',
      NULL,
      ' 6- 2-1974',
      41,
      NULL,
      0.102889,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.762702,
      0.887094,
      NULL,
      0,
      3,
      1.902381,
      0,
      1.190594,
      1.086347,
      0,
      0,
      0.186071,
      0.329875,
      1.850498,
      NULL,
      0.835654,
      0.965171,
      0.688991,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.454745,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835855,
      1,
      NULL,
      1,
      0.533725,
      0,
      0.872507,
      1,
      0,
      NULL,
      3.568200,
      1,
      1,
      1,
      1.842798,
      0.017674,
      1.357439,
      NULL,
      NULL,
      NULL,
      0,
      3.093863,
      0.582610,
      0,
      NULL,
      1.411918,
      0,
      1.156022,
      5.833362,
      NULL,
      2.598456,
      NULL,
      NULL,
      0.779931,
      2,
      1,
      1,
      5.524719,
      1,
      5.699438,
      4.388890,
      1.740250,
      1.307445,
      4.601947,
      3,
      NULL,
      NULL,
      NULL,
      0.585877,
      NULL,
      NULL,
      6.907433,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.782577,
      0,
      1,
      0.805885,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      7.496754,
      NULL,
      0.033605,
      1.181831,
      NULL,
      1.941676,
      NULL,
      3.304163,
      0.882541,
      0.775696,
      2,
      1,
      3,
      2.725519,
      1.630773,
      0.810298,
      4.151185,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      2.979023,
      4,
      3,
      5.142400,
      4,
      4.954573,
      6.298683,
      5,
      NULL,
      1.207574,
      NULL,
      1.724518,
      0.227010,
      NULL,
      0,
      1,
      1,
      0,
      0.454122,
      1,
      NULL,
      1.610761,
      1.229760,
      1,
      1.982273,
      1.909253,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.508201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.095874,
      '24331',
      '',
      '',
      0.723588,
      '',
      '',
      '',
      3,
      '3441',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


