set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127031';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      7.935020,
      NULL,
      106,
      6,
      3,
      NULL,
      NULL,
      NULL,
      '11-10-1980',
      37,
      NULL,
      1.621730,
      NULL,
      4.992813,
      0.716374,
      3,
      1.445937,
      1.052998,
      2.354376,
      0.388489,
      NULL,
      3,
      0.802947,
      1,
      0,
      NULL,
      1.578990,
      1,
      0,
      2.425269,
      1,
      1,
      1.654439,
      NULL,
      1.953397,
      2,
      1,
      2,
      1,
      2.867308,
      1.966669,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.892430,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.684858,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.869869,
      NULL,
      0.400046,
      NULL,
      1.190622,
      0,
      1.980828,
      1,
      0,
      0.968897,
      1.849032,
      0.448497,
      1,
      0,
      NULL,
      1,
      1,
      0.314181,
      NULL,
      1.044831,
      1,
      0,
      0.228589,
      1.348142,
      1.745642,
      NULL,
      1,
      1,
      0.541637,
      0.504647,
      1.128707,
      1,
      1.816350,
      0.488653,
      NULL,
      0,
      1.492739,
      NULL,
      5,
      4.509629,
      2,
      0,
      0.580466,
      1,
      2,
      1.384644,
      0,
      0.732448,
      NULL,
      NULL,
      1,
      1.240338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.901145,
      0.318273,
      0,
      1,
      1.689788,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.662008,
      NULL,
      1.694631,
      0,
      0,
      5,
      NULL,
      0.073224,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308568,
      1.276884,
      NULL,
      3.229234,
      NULL,
      2,
      1.630641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.418364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.605180,
      NULL,
      1,
      1,
      1.251964,
      1,
      1,
      0.720174,
      NULL,
      1.824647,
      1,
      NULL,
      1,
      1,
      1,
      0.604721,
      0.040534,
      0.660651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.924368,
      '22220',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      4.905638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


