set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127031';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '214',
      '03',
      49.644330,
      43.868329,
      '4123403',
      91.861962,
      1,
      NULL,
      0,
      '214121',
      2.839606,
      ' 7- 4-1995',
      27,
      NULL,
      0.730126,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0.721411,
      1.324216,
      2.794110,
      0,
      1.731026,
      1,
      0,
      1.093790,
      0,
      0.923063,
      5,
      1.443807,
      5.119815,
      0,
      NULL,
      0.379701,
      1,
      0,
      1,
      NULL,
      2.769154,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.026626,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      0.374159,
      0,
      1,
      0.956120,
      0,
      0.583152,
      1,
      0.869267,
      1.722718,
      NULL,
      0,
      NULL,
      0,
      1.946605,
      NULL,
      0.464613,
      0,
      NULL,
      NULL,
      NULL,
      0.572925,
      1,
      0.433467,
      1,
      NULL,
      0.576373,
      0,
      NULL,
      1.391730,
      NULL,
      NULL,
      0,
      4,
      1,
      5.627162,
      1,
      4,
      0.151381,
      4,
      2,
      NULL,
      1.970731,
      4.293098,
      0,
      NULL,
      NULL,
      4.666108,
      0.778239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991641,
      NULL,
      NULL,
      0,
      1.851912,
      0,
      0.471207,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620130,
      NULL,
      NULL,
      NULL,
      NULL,
      1.979303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042926,
      NULL,
      2.750252,
      0.233711,
      0.822122,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.066471,
      NULL,
      3.632095,
      0,
      3,
      0,
      NULL,
      0.850239,
      0.712492,
      0.247904,
      NULL,
      1.440266,
      1,
      1,
      0.359481,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.001267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '12404',
      '',
      '',
      0.476376,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      5,
      0.532380,
      2.980981,
      1.771582,
      NULL,
      3.104214,
      3,
      NULL,
      3.782212);
commit;
end;
/


