set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127031';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '114',
      NULL,
      19.287739,
      16.544140,
      '3441143',
      108.046302,
      5,
      1.298602,
      2,
      '423113',
      0.357535,
      ' 7-21-1989',
      15,
      63,
      1,
      NULL,
      0,
      NULL,
      2,
      0.165748,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0.695668,
      NULL,
      3,
      2.325487,
      0.890882,
      5,
      1,
      2.686712,
      1.228684,
      NULL,
      0,
      1.805862,
      0,
      NULL,
      0,
      1.632756,
      0.422638,
      NULL,
      NULL,
      1.018820,
      NULL,
      NULL,
      0.670493,
      1.269096,
      1.343350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.762510,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.734854,
      1,
      1.771342,
      0.594090,
      1.227672,
      1,
      0,
      1.011984,
      NULL,
      1,
      0.286039,
      0.000189,
      0.484800,
      1.153238,
      1.520087,
      0,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      1.282641,
      1.928352,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.551678,
      1,
      1,
      1,
      1.999815,
      1.800290,
      4.534488,
      NULL,
      1.335703,
      NULL,
      1.046231,
      5.628640,
      4.221841,
      0,
      1,
      2.876834,
      0.607849,
      NULL,
      NULL,
      2.364570,
      0.492013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.301856,
      1.294345,
      0,
      1,
      0.768782,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.893930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.808708,
      3.814690,
      1,
      NULL,
      NULL,
      NULL,
      0.159315,
      0.507732,
      0.266280,
      1,
      NULL,
      NULL,
      1.447080,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.822370,
      0.813222,
      2,
      0,
      NULL,
      0,
      1,
      0,
      3.496281,
      0.685184,
      0,
      NULL,
      NULL,
      1,
      0.351498,
      1.953582,
      NULL,
      NULL,
      1.507117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '04222',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      2,
      '14100',
      '',
      '',
      3.798558,
      5.229475,
      0,
      0,
      3,
      1.173841,
      0,
      3.079738,
      NULL);
commit;
end;
/


