set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127031';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '044',
      '13123001',
      NULL,
      2.714270,
      NULL,
      191,
      2,
      1.495922,
      0,
      NULL,
      NULL,
      ' 4-19-1979',
      1.973790,
      31.582208,
      1.979485,
      NULL,
      1.217342,
      0.954027,
      NULL,
      0,
      1.710379,
      1.870246,
      1,
      1,
      1.334001,
      NULL,
      7.231845,
      0,
      NULL,
      1.580531,
      5.646706,
      0,
      11,
      1.638714,
      NULL,
      NULL,
      0,
      1,
      5.967996,
      0,
      2,
      NULL,
      0.053435,
      0.538568,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.879866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.782794,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.105776,
      0.232968,
      1.449426,
      NULL,
      1,
      1.279588,
      0,
      1.934922,
      0,
      0,
      0,
      NULL,
      0.630132,
      1,
      NULL,
      0.922067,
      0,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1.788639,
      1.121605,
      4.569879,
      2.480435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.850884,
      NULL,
      1,
      0,
      4,
      7,
      7,
      4,
      2.006060,
      2.642284,
      1,
      4.910086,
      4.933521,
      5.828885,
      NULL,
      NULL,
      0,
      1.307148,
      0.249009,
      0.070662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.951122,
      0.078379,
      NULL,
      1,
      NULL,
      0,
      0.002385,
      0.683311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.349014,
      NULL,
      1.173669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.919692,
      0,
      2.713997,
      NULL,
      0.646625,
      NULL,
      5.958288,
      1,
      3.278953,
      7.361548,
      0,
      2,
      1.407836,
      NULL,
      NULL,
      NULL,
      1,
      2.874899,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.440985,
      NULL,
      0.433419,
      3,
      2.359532,
      0,
      1.097482,
      NULL,
      1.106621,
      NULL,
      0.205609,
      0.128342,
      1,
      1,
      1.971364,
      0,
      1,
      0.802603,
      0.608261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '42313',
      '',
      '',
      1.072059,
      '',
      '',
      '',
      3,
      '22334',
      '',
      '',
      3.535873,
      6,
      3,
      0.626778,
      3,
      1.555347,
      3.806141,
      3,
      1);
commit;
end;
/


