set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127031';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3134',
      NULL,
      63.057087,
      76,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      '204201',
      2.047358,
      ' 9-22-1997',
      7,
      19.761658,
      1.794602,
      NULL,
      15,
      3,
      0.856589,
      NULL,
      NULL,
      NULL,
      1.082064,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      0.340927,
      0.981307,
      NULL,
      1.914008,
      1,
      0,
      0,
      0,
      NULL,
      5.035490,
      2,
      NULL,
      0.652549,
      0.466329,
      NULL,
      2,
      0.712892,
      NULL,
      NULL,
      NULL,
      0,
      0.574665,
      NULL,
      0.429648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.473026,
      NULL,
      1,
      3.431797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.311614,
      3.732482,
      5,
      0,
      2,
      3.440686,
      NULL,
      1,
      1,
      NULL,
      0.167991,
      5.068681,
      1.155481,
      0,
      0,
      0.495951,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.850413,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      1.490651,
      1,
      NULL,
      0,
      0,
      0,
      4.541621,
      1.886303,
      3.988643,
      NULL,
      5,
      4,
      4,
      3.771938,
      NULL,
      4,
      7.049861,
      5.031123,
      5.734818,
      3.368815,
      3.762907,
      2,
      2,
      7.729685,
      NULL,
      5.981979,
      1,
      3.687074,
      0.324823,
      1,
      1,
      1,
      0,
      NULL,
      4.802735,
      0.555721,
      1.551381,
      3,
      NULL,
      3,
      NULL,
      2.816855,
      1.622480,
      NULL,
      NULL,
      NULL,
      NULL,
      0.052112,
      1.165679,
      1,
      2,
      NULL,
      2.026813,
      2,
      0.227569,
      0.860316,
      3.593923,
      0.354411,
      NULL,
      2.827793,
      0.227434,
      0.808053,
      5.810326,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.147987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.452093,
      NULL,
      1,
      2,
      2.485540,
      0.590457,
      0.814975,
      NULL,
      0,
      1.533765,
      NULL,
      0,
      NULL,
      0.979579,
      0.146276,
      NULL,
      NULL,
      0,
      1.528851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.941989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '12242',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      2.644229,
      3.351454,
      3,
      0.077725,
      3.035758,
      4.470553,
      2,
      NULL,
      NULL);
commit;
end;
/


