set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127031';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4004',
      '42320033',
      54.744382,
      13,
      '0234144',
      54.874890,
      1,
      0.706151,
      NULL,
      '404034',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.081051,
      1.907516,
      1.697196,
      NULL,
      3,
      0.277709,
      3,
      1,
      4,
      0,
      1.669554,
      NULL,
      1,
      NULL,
      2.433050,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      2.632329,
      2,
      1,
      1,
      NULL,
      NULL,
      0.304874,
      NULL,
      2,
      1.051831,
      1,
      1,
      1.904087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.344171,
      0.302232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.439322,
      NULL,
      NULL,
      0,
      3.230381,
      NULL,
      NULL,
      0.280375,
      1,
      1.537049,
      1,
      NULL,
      0,
      0.552642,
      1,
      1,
      NULL,
      0.043581,
      0.260796,
      NULL,
      0.817320,
      0.741180,
      0.134393,
      1,
      1.731182,
      1,
      0.981207,
      1,
      1.580689,
      NULL,
      NULL,
      1.329709,
      0,
      0,
      NULL,
      0.620504,
      0,
      5.944110,
      NULL,
      7,
      NULL,
      0,
      4,
      1,
      2.117068,
      NULL,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.561158,
      0,
      1,
      0.631927,
      0.421477,
      NULL,
      1.202973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.007995,
      NULL,
      NULL,
      1.808621,
      1.363804,
      2,
      0,
      0.802929,
      0.892328,
      0.191405,
      0.455776,
      6.257060,
      0.656929,
      1.532514,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2,
      3,
      NULL,
      2,
      1.942796,
      NULL,
      NULL,
      NULL,
      0,
      6.068719,
      1.542130,
      1.224616,
      1,
      1,
      5.177188,
      NULL,
      2.337987,
      NULL,
      2.851273,
      2,
      3,
      2.640667,
      1.730865,
      1,
      2.498297,
      NULL,
      1.729268,
      0.876991,
      1,
      0.806554,
      1,
      NULL,
      0.108901,
      0,
      0.407712,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.073710,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '1234',
      '',
      '',
      0,
      1,
      0,
      2.611827,
      0.082090,
      4,
      2.471518,
      4.514094,
      2.591723);
commit;
end;
/


