set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-8-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      NULL,
      NULL,
      '3414002',
      12,
      3,
      0.340845,
      NULL,
      '342204',
      0.484934,
      ' 9- 0-1994',
      32,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.788626,
      NULL,
      1.013976,
      0,
      0.439500,
      0,
      NULL,
      NULL,
      1.306562,
      1,
      0.274491,
      0,
      0.269473,
      NULL,
      0.243311,
      1.160243,
      1,
      1.281749,
      0,
      NULL,
      2,
      2,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.824334,
      NULL,
      NULL,
      NULL,
      0.928443,
      1,
      3.221306,
      0.368624,
      0.510318,
      2.452886,
      0.563621,
      1.723882,
      2.897579,
      0.515322,
      0,
      1,
      0.640908,
      1.623658,
      NULL,
      1.301716,
      2,
      3,
      1,
      1,
      0.391101,
      4,
      NULL,
      NULL,
      0,
      0.554889,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.101499,
      0,
      1,
      0,
      0.259125,
      1.916739,
      1.591501,
      1.151277,
      0,
      0.894261,
      NULL,
      1,
      1,
      1,
      0.974571,
      1,
      NULL,
      NULL,
      NULL,
      6.309195,
      1.904749,
      NULL,
      NULL,
      0,
      6.869124,
      1,
      1.904720,
      5,
      7.011829,
      1,
      3,
      5,
      5.232175,
      0,
      3.880957,
      8,
      5,
      9,
      3,
      1,
      1.941183,
      4.873575,
      0.384320,
      3,
      0.646975,
      NULL,
      0.216831,
      NULL,
      1,
      5,
      1.855307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1.831184,
      1.452436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.159637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594624,
      NULL,
      1.824566,
      0,
      0,
      1.387828,
      NULL,
      NULL,
      NULL,
      NULL,
      4.429119,
      0.592630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.495291,
      NULL,
      0,
      0,
      0.348915,
      2,
      0.201043,
      NULL,
      0,
      1,
      0,
      NULL,
      0.748807,
      1,
      0,
      0.295476,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '02011',
      '',
      NULL,
      0,
      '',
      '',
      '',
      1.963663,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


