set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-8-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      4,
      5,
      0.892743,
      2,
      '422014',
      0.908416,
      ' 6-12-1992',
      12.357892,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.795615,
      1,
      1.101476,
      0,
      1.027854,
      0,
      1.476588,
      2.896514,
      1.164474,
      0.397100,
      0.277657,
      0.845806,
      0.366039,
      1,
      0,
      0.533115,
      1.212352,
      3,
      NULL,
      1.807734,
      3.398798,
      2,
      1,
      1.243460,
      NULL,
      1.740714,
      NULL,
      NULL,
      0.364077,
      NULL,
      NULL,
      4,
      0,
      1.735055,
      2.902307,
      1.757536,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0,
      1.871774,
      1,
      0,
      NULL,
      NULL,
      0.731674,
      0,
      NULL,
      6,
      3,
      0,
      1.216421,
      1.831941,
      NULL,
      NULL,
      0.303115,
      NULL,
      NULL,
      0,
      1.074698,
      1.338216,
      0,
      0,
      NULL,
      0,
      1.918428,
      NULL,
      0,
      0,
      1,
      1.829122,
      0.868176,
      1,
      1,
      0.807927,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.420054,
      0.928276,
      5,
      NULL,
      1.869841,
      0.250428,
      1,
      2.188975,
      1,
      3.229500,
      2.540869,
      5.140925,
      8.376809,
      1.958851,
      5,
      2,
      NULL,
      3.364451,
      NULL,
      NULL,
      6.855760,
      1,
      4,
      4,
      1.425251,
      NULL,
      1.026664,
      1,
      0,
      3.942927,
      0.218030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.038726,
      0,
      2,
      NULL,
      1.003110,
      1.252545,
      1,
      1.268704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.854478,
      1.348735,
      NULL,
      NULL,
      NULL,
      5,
      3.480999,
      3,
      1,
      0,
      1,
      1.316999,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.724311,
      1,
      1.584375,
      1,
      0,
      3.580701,
      3,
      2,
      0,
      2.264842,
      3,
      1.597371,
      0,
      NULL,
      NULL,
      NULL,
      0.734680,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.243264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '21202',
      '',
      '',
      0.038660,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


