set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      NULL,
      '4011214',
      NULL,
      3,
      2.583024,
      2,
      '423340',
      0.355102,
      ' 8-29-1977',
      57,
      NULL,
      0.533130,
      NULL,
      4,
      0.224678,
      0,
      0.994338,
      0,
      NULL,
      0,
      0.470901,
      0,
      NULL,
      0.426591,
      1.513990,
      1.910117,
      0,
      0.367778,
      NULL,
      1.911653,
      1,
      0,
      NULL,
      0.518475,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.363393,
      NULL,
      NULL,
      8.449080,
      NULL,
      1.076159,
      0.688821,
      1.643835,
      1,
      3.087266,
      1,
      1.124989,
      0.876578,
      0.945145,
      0,
      0,
      3,
      1,
      NULL,
      1.282041,
      0.116396,
      NULL,
      1.832885,
      0,
      0,
      0.506086,
      1,
      1,
      1.119699,
      1.131786,
      NULL,
      NULL,
      1.273248,
      NULL,
      NULL,
      1,
      0.830400,
      1,
      0.019219,
      NULL,
      0,
      1,
      1,
      1.469659,
      0.422000,
      0,
      NULL,
      NULL,
      1.224169,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.894122,
      1.521052,
      0,
      2.428622,
      NULL,
      4.142305,
      1.735296,
      8.348853,
      2.230524,
      NULL,
      NULL,
      0.114630,
      0.911685,
      NULL,
      0.284259,
      6,
      NULL,
      0.806375,
      1,
      NULL,
      NULL,
      7,
      3,
      3,
      1.038227,
      0.978302,
      NULL,
      3.165479,
      NULL,
      0,
      0.885176,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.872457,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      1.218259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.553183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3.931059,
      1,
      NULL,
      NULL,
      NULL,
      7,
      1,
      8,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      3.664419,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420911,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0.614101,
      1.746662,
      NULL,
      1.716467,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '34213',
      '',
      '',
      0,
      '',
      '',
      '',
      0.046837,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


