set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      NULL,
      NULL,
      '3204412',
      NULL,
      1,
      NULL,
      2,
      '324432',
      0,
      ' 3-20-1993',
      18,
      NULL,
      1.682956,
      NULL,
      19.038664,
      3,
      NULL,
      1,
      0,
      0.946732,
      NULL,
      0,
      1.998050,
      0,
      1.232086,
      0,
      0,
      NULL,
      0.980867,
      1,
      1,
      1.071799,
      9,
      1,
      7,
      1.517588,
      3,
      0,
      0.465697,
      0,
      NULL,
      1.863226,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0.758321,
      1,
      2,
      1.506139,
      2.307960,
      0,
      1.297740,
      NULL,
      NULL,
      1.324716,
      1,
      0.825327,
      1,
      0,
      4,
      3,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.593150,
      0.269914,
      1,
      0,
      1,
      1,
      1,
      0,
      0.955702,
      NULL,
      1,
      1,
      1.652443,
      1,
      1.271113,
      NULL,
      NULL,
      0.163084,
      1.129519,
      NULL,
      1.332126,
      1,
      0.472216,
      1.296254,
      3,
      0,
      9.424954,
      NULL,
      1.343314,
      6,
      0.097346,
      3.029338,
      1.535644,
      1,
      2.121665,
      0.334990,
      4.497732,
      4,
      0.015764,
      3,
      8,
      3.844166,
      7,
      6,
      NULL,
      2.077875,
      3.956529,
      4,
      NULL,
      NULL,
      0,
      NULL,
      1.193317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0.142996,
      5.685207,
      0.367977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.202457,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.289185,
      0.436837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3.349625,
      0,
      2,
      1,
      0.158766,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827950,
      NULL,
      0,
      3.311278,
      2.919525,
      0,
      0,
      1,
      1.138244,
      1,
      2,
      1,
      0,
      1,
      0.691724,
      1.458278,
      0,
      1.099434,
      0.144817,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.541682,
      NULL,
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


