set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8412703';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      NULL,
      '4012242',
      NULL,
      0,
      1,
      1,
      '122234',
      0,
      ' 8- 4-1996',
      NULL,
      NULL,
      0,
      NULL,
      9,
      0.519075,
      1.174392,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      0.581408,
      1.514567,
      1.271722,
      1,
      0.030809,
      NULL,
      3.622609,
      0.830773,
      0,
      1,
      NULL,
      1.386575,
      1,
      3.841745,
      1,
      NULL,
      0.949236,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5.521698,
      0.206107,
      1.238073,
      1,
      1.552063,
      1,
      3.846833,
      0.898093,
      0.569348,
      0.269021,
      1.193751,
      3,
      3.931184,
      3.611925,
      NULL,
      3,
      2,
      0,
      NULL,
      NULL,
      6,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.157912,
      0.510939,
      1,
      NULL,
      1.286639,
      NULL,
      NULL,
      1,
      NULL,
      1.860877,
      0,
      NULL,
      NULL,
      NULL,
      1.495997,
      1,
      NULL,
      1.513824,
      NULL,
      NULL,
      NULL,
      4.889123,
      0.248070,
      1.453035,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      4.064618,
      7,
      NULL,
      3,
      NULL,
      0,
      3.600155,
      NULL,
      NULL,
      NULL,
      7.045470,
      NULL,
      11.138998,
      6.546921,
      9.701815,
      0,
      3,
      0,
      1,
      0,
      0.740762,
      1.306765,
      0.698505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.032399,
      0.615407,
      NULL,
      NULL,
      0.503039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.210615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.386740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.794606,
      2.915485,
      1.418403,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.248647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.548796,
      NULL,
      3.980500,
      2,
      NULL,
      3.695841,
      NULL,
      NULL,
      0,
      0,
      1.483655,
      1,
      1.513127,
      NULL,
      1,
      NULL,
      1.207267,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.744469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '14034',
      '',
      '',
      0.252054,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


